package eu.europa.ec.taxud.cesop.xsd;

import javax.xml.stream.XMLStreamException;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchemaFactory;

/**
 * The interface Xsd schema.
 */
public interface XsdSchema {

    String CURRENT_VERSION = "4.03";

    List<String> SUPPORTED_VERSIONS = Collections.unmodifiableList(Arrays.asList("4.02", "4.03"));

    Map<String, XMLValidationSchema> VERSION_2_XSD = SUPPORTED_VERSIONS.stream().collect(Collectors.toMap(
            version -> version,
            version -> loadSchemaResource("/xsd/" + version + "/PaymentData.xsd")
    ));

    /**
     * Load schema resource xml validation schema.
     *
     * @param resourcePath the resource path
     * @return the xml validation schema
     */
    static XMLValidationSchema loadSchemaResource(final String resourcePath) {
        final URL classpathResource = XsdSchema.class.getResource(resourcePath);
        if (classpathResource == null) {
            throw new IllegalArgumentException("XSD schema not found: " + resourcePath);
        }
        try {
            return XMLValidationSchemaFactory.newInstance(XMLValidationSchema.SCHEMA_ID_W3C_SCHEMA).createSchema(classpathResource);
        } catch (final XMLStreamException e) {
            throw new IllegalStateException(String.format("Failed to create schema from resource '%s'", resourcePath), e);
        }
    }
}
